function [ xNormed, xOffsets, yNormed, yUnnormed] = prepareData( dataMat )
%PREPAREDATA Summary of this function goes here
%   Detailed explanation goes here

yNormed = dataMat(:,1);
yUnnormed = dataMat(:,1);
svrObs = dataMat(:,2:end);
xNormed = cell(numel(yNormed),1);

% the offsets are useful later on, when predicting
xOffsets = zeros(numel(yNormed), 1);

    for i=1:numel(yNormed)
        
        xNormed{i} = zeros(numel(yNormed{i}), size(svrObs,2));
        
        for j=1:size(svrObs,2)
        
            % Due to the way predictor data was generated, some of them were
            % slightly shorter, make sure lengths are the same here
            if(numel(yNormed{i}) > numel(svrObs{i,j}))
                svrObs{i,j} = [svrObs{i,j}; zeros(numel(yNormed{i}) - numel(svrObs{i,j}),1)];
            elseif(numel(yNormed{i}) < numel(svrObs{i,j}))
                svrObs{i,j} = svrObs{i,j}(1:end - (numel(svrObs{i,j}) - numel(yNormed{i})));
            end
            xNormed{i}(:,j) = svrObs{i,j};
            xOffsets(i) = xOffsets(i) + mean(xNormed{i}(:,j));

            % normalise the predictors
            xNormed{i}(:,j) = xNormed{i}(:,j) - mean(xNormed{i}(:,j));
            if(std(xNormed{i}(:,j))~=0)                
                xNormed{i}(:,j) = xNormed{i}(:,j) / std(xNormed{i}(:,j));
            end
        end

        % calculate the actual offset (Across all predictors)
        xOffsets(i) = xOffsets(i) / size(svrObs, 2);

        % normalise y as well
        yNormed{i} = yNormed{i} - mean(yNormed{i});
        if(std(yNormed{i})~=0)    
            yNormed{i} = yNormed{i} / std(yNormed{i});
        end
    end

end

